##########################################################################################
#
#    Application presented in:            
#    Bayer, F.M. and Cribari-Neto, F. (2014) Model selection criteria 
#       in beta regression with varying dispersion. In http://arxiv.org/abs/1405.3718
#
#########################################################################################

library(gamlss)

source("auto-beta-reg.r") 
  
# Dyslexia
data<-read.table("dyslex.txt",h=T) 
attach(data)

# fitting the full model
fit_dislex_full <-gamlss(resp~QI+dyslex+intera+QI2+invQI+interaQI2, family=BE)

# using the auto.beta.reg function (PS5)
fit_dislex <- auto.beta.reg(fit_dislex_full) 

