##########################################################################################
#
#    Application presented in:            
#    Bayer, F.M. and Cribari-Neto, F. (2014b) Bootstrap-based model 
#      selection criteria for beta regressions. http://arxiv.org/abs/1405.4525
#
#########################################################################################

library(gamlss)

source("auto-beta-reg.r") 
  
# Dados de gastos com alimentacao
data<-read.table("food.txt",h=T) 
attach(data)

set.seed(1)

# fitting the full model
fit_food_full = gamlss(Y~x2+x3+x4+x5+x6,family=BE)

# using the auto.beta.reg function with BQCV in step 1 and 632QCV in step 2
fit_food <- auto.beta.reg(fit_food_full,crit1="BQCV",crit2="632QCV") 

# using the auto.beta.reg function with 632QCV and BQCV (with just 100 resamples)
fit_food <- auto.beta.reg(fit_food_full,crit1="632QCV",crit2="BQCV",B=100) 

