linkfun <- function(mu,lambda) {
  ret<-log((((1-mu)^(-lambda))-1)/lambda)
  as.vector(ret)
}

linkinv <- function(eta,lambda) {
  
  eta<- pmax(-.Machine$double.xmax, eta)
  eta<- pmin(.Machine$double.xmax, eta)
  
  ret<-(1-(1+lambda*exp(eta))^(-1/lambda))
  
  ret<- pmin(ret, 1-.Machine$double.eps )
  ret<- pmax(ret, .Machine$double.eps )
  as.vector(ret)
} 

mu.eta <- function(eta,lambda) {
  
  eta<- pmax(-.Machine$double.xmax, eta)
  eta<- pmin(.Machine$double.xmax, eta)
  
  ret<- exp(eta)*(1+lambda*exp(eta))^(-(1+(1/lambda)))
  
  ret<- pmax(ret, .Machine$double.eps)
  as.vector(ret)
}

diflink <- function(mu,lambda) {
  ret<-((lambda*(1-mu)^(-(lambda+1)))/((1-mu)^(-lambda)-1))
  as.vector(ret)
}

beta.nul<-function(y){
  y <- as.vector(y)
  
  #loglik null
  loglikt <- function(theta){
    mu <- theta[1]
    sigma <- theta[2]
    phi <- ((1-(sigma^2))/(sigma^2))
    
    ll <- sum(lgamma(phi)-lgamma(mu*phi)-lgamma((1-mu)*phi)+(mu*phi-1)*log(y)+((1-mu)*phi-1)*log(1-y))
    ll
  }
  
  mu_ini <-mean(y)
  
  vm.vy<-(mu_ini*(1-mu_ini))/var(y)
  
  sigma_ini <- sqrt(1/(vm.vy+1))
  
  ini_nul <- c(mu_ini,sigma_ini)
  
  opt_nul <- optim(ini_nul, loglikt, control = list(fnscale = -1))
  
  k <- c()
  k$loglik<- opt_nul$value
  return(k)
}


"fit.reset" <- function(x,z,y,model){
  
  y <- as.vector(y)
  x <- as.matrix(x)
  x1 <- cbind(rep(1,length(y)),x)
  z <- as.matrix(z)
  z1 <- cbind(rep(1,length(y)),z)
  
  r <- ncol(x1)
  s <- ncol(z1)
  n <- length(y)
  
  eta1<-c()
  eta2<-c()
  
  
  lambda1<-model$lambda1
  lambda2<-model$lambda2
  
  loglik <- function(theta){
    beta <- as.vector(theta[1:r])
    gamma <- as.vector(theta[(r+1):(r+s)])
    
    eta1 <- as.vector(x1%*%beta)
    eta2 <- as.vector(z1%*%gamma)
    
    mu <- as.vector(linkinv(eta1,lambda1))
    sigma <- as.vector(linkinv(eta2,lambda2))
    phi <- as.vector(((1-(sigma^2))/(sigma^2)))
    
    ll <- sum(lgamma(phi)-lgamma(mu*phi)-lgamma((1-mu)*phi)+(mu*phi-1)*log(y)+((1-mu)*phi-1)*log(1-y))
    ll
  }
  
  escore <- function(theta){
    beta <- as.vector(theta[1:r])
    gamma <- as.vector(theta[(r+1):(r+s)])
    
    eta1 <- as.vector(x1%*%beta)
    eta2 <- as.vector(z1%*%gamma)
    
    mu <- as.vector(linkinv(eta1,lambda1))
    sigma <- as.vector(linkinv(eta2,lambda2))
    phi <- as.vector(((1-(sigma^2))/(sigma^2)))
    ystar = as.vector(log( y / (1.0 - y) ))
    mustar = as.vector(digamma(mu*phi)-digamma((1.0-mu)*phi))
    
    PHI = diag( phi )
    T = diag(as.vector(mu.eta(eta1,lambda1)))
    H = diag(as.vector(mu.eta(eta2,lambda2)))
    
    ydag = as.vector(log( 1.0 - y ))
    mudag = as.vector(digamma((1.0 - mu) * phi) - digamma(phi))
    M = diag(mu)
    a = as.vector(((-2.0 / sigma^3)*(M %*% (ystar-mustar)+(ydag-mudag))))
    rho = as.vector((1/lambda1)*((1/(exp(-eta1)+lambda1))-(log(1+lambda1*exp(eta1))/lambda1))*((1+lambda1*exp(eta1))^(-1/lambda1)))
    varrho = as.vector((1/lambda2)*((1/(exp(-eta2)+lambda2))-(log(1+lambda2*exp(eta2))/lambda2))*((1+lambda2*exp(eta2))^(-1/lambda2)))
    
    Ubeta  = t(x1) %*% T %*% PHI %*% (ystar-mustar)
    Ugama  = t(z1) %*% H %*% a
    
    c(Ubeta,Ugama)
  }
  
  
  #chutes iniciais
  ystar = log( y / (1.0 - y) )
  betaols<- (lm.fit(x1, ystar))$coefficients
  etaols = x1 %*% betaols
  muols = exp(etaols) / (1.0 + exp(etaols))
  varols = as.numeric(t(ystar - etaols) %*% (ystar-etaols)) / ((n-r)*((1 /(muols*(1-muols)))^(2)))
  phiols = ( muols * (1.0-muols) / varols ) - 1.0
  sigmaini = sqrt( 1.0 / (1.0 + phiols))
  gamaols = (lm.fit(z1, log(sigmaini/(1.0-sigmaini))))$coefficients
  ini <- c(betaols,gamaols)

  opt <- optim(ini, loglik, escore, 
               method = "BFGS", control = list(fnscale = -1, maxit = 500, reltol = 1e-9))
  
  if (opt$conv != 0)
    warning("FUNCTION DID NOT CONVERGE!")
  
  
  k <- c()
  coef <- opt$par
  k$coef <- coef
  k$conv <- opt$convergence
  k$loglik <- opt$value
  k$counts <- as.numeric(opt$counts[1])
  k$betas <- opt$par[1:r]
  k$gammas <- opt$par[(r+1):(r+s)]
  k$lambda1 <- lambda1
  k$lambda2 <- lambda2
  
  return(k)
}

reset<-function(model){
  y <- as.vector(model$y)
  x<-cbind(model$mu.x,model$mu.lp^2)
  z<-cbind(model$sigma.x,model$mu.lp^2)
  
  ajusteh0<-model
  ajusteh1<-fit.reset(x,z,y,model)
  
  k<-c()
  
  k$stat<-2*(ajusteh1$loglik-ajusteh0$loglik)
  stat<-2*(ajusteh1$loglik-ajusteh0$loglik)
  k$pvalue<-1-pchisq(2*(ajusteh1$loglik-ajusteh0$loglik),2)
  print("If p-value > alpha then the model is specified correctly.",quote=F)
  return(k)
}


# Diagnostic function
# model -> adjusted model
# sim -> number of Monte Carlo simulations 
# conf -> confidence of the simulated envelopes
# pch -> type of points
# pdf = 1 -> print the graphs in pdf file
diag.br.fit <- function(model=fit.model,sim=100,conf=.90, pch=1, pdf=0) {
  main = "Half-Normal Plot of Residuals"
  ylab= "Residuals (absolute values)"
  xlab= "Normal quantiles"
  alfa <-(1-conf)/2
  X <- model$mu.x
  Z <- model$sigma.x
  y <-model$y
  n <- nrow(X)
  r <- ncol(X)+1
  s <- ncol(Z)+1
  m <- model$mu.fv
  
  si <- model$sigma.fv
  res <- model$resid.type2
  e <- matrix(0,n,sim)
  e1 <- numeric(n)
  e2 <- numeric(n)
  phi <- (1-si^2)/(si^2)
  
  i<-1
  while(i<=sim) {
    resp <- rbeta(n, m*phi, (1-m)*phi)
    fit <- try(br.fit(X,Z,resp,diag=0),silent=T)
    if(class(fit) != "try-error"){
      if(fit$conv==0){
        ti <- fit$resid.type2
        eo <- sort(abs(fit$resid.type2))
        e[,i] <- eo
        i<- i+1
      }
    }
  }
  
  for(i in 1:n) {
    eo <- sort(e[i,])
    e1[i] <- quantile(eo,alfa)
    e2[i] <- quantile(eo,1-alfa)
  }
  
  par(mfrow=c(2,2))
  par(family="Times") 
  par(mar=c(2.7, 2.5, 2, 1)) 
  par(mgp=c(1.5, 0.8, 0))
  
  t<-seq(-5,n+6,by=1)
  j<-seq(n)
  
  Cook <- model$Cook
  
  plot(Cook,main="Cook-like distance",xlab="Index",ylab=expression(plain(C)), pch = pch)
  
  plot(j, res,main="Residual vs. index",xlab="",ylab="", pch = pch,ylim=c(min( c(-4,res) ),max(c(4,res) ) )) 
  lines(t,rep(-3,n+12),lty=2,col=1)
  lines(t,rep(3,n+12),lty=2,col=1)
  lines(t,rep(-2,n+12),lty=3,col=1)
  lines(t,rep(2,n+12),lty=3,col=1)
  
  plot(y, m,main="Observed values vs. fitted values",xlab="",ylab="", pch = pch) 
  lines(c(0,1),c(0,1),lty=2)
  
  
  med <- apply(e,1,median)
  qq <- qnorm((n+1:n+.5)/(2*n+1.125))
  plot(qq, sort(abs(res)), ylim = range(abs(res), e1, e2), 
       pch=pch, main=main, xlab=xlab, ylab=ylab)
  
  lines(qq,e1,lty=1)
  lines(qq,e2,lty=1)
  lines(qq,med,lty=2) 
  
  if(pdf==1)
  {
    mar_b<-2.5
    mar_e<-2.5
    mar_c<-0.5
    mar_d<-0.5
    dist_text<-1.5
    dist_tick<-0.5
    
    
    pdf(file = "Cook.pdf",width = 4, height = 4,family = "Times")
    par(mar=c(mar_b, mar_e, mar_c, mar_d)) 
    par(mgp=c(dist_text, dist_tick, 0))
    plot(Cook,xlab="Index",ylab=expression(plain(C)), pch = pch)
    dev.off()
    
    pdf(file = "resid_v_ind.pdf",width = 4, height = 4,family = "Times")
    par(mar=c(mar_b, mar_e, mar_c, mar_d)) 
    par(mgp=c(dist_text, dist_tick, 0))
    plot(j, res,xlab="Index",ylab="Residuals", pch = pch,ylim=c(min( c(-4,res) ),max(c(4,res) ) ) ) 
    lines(t,rep(-3,n+12),lty=2,col=1)
    lines(t,rep(3,n+12),lty=2,col=1)
    lines(t,rep(-2,n+12),lty=3,col=1)
    lines(t,rep(2,n+12),lty=3,col=1)
    dev.off()
    
    pdf(file = "obs_v_fitted.pdf",width = 4, height = 4,family = "Times")
    par(mar=c(mar_b, mar_e, mar_c, mar_d)) 
    par(mgp=c(dist_text, dist_tick, 0))
    plot(y, m,xlab="Observed",ylab="Fitted", pch = pch) 
    lines(c(0,1),c(0,1),lty=2)
    dev.off()
    
    pdf(file = "envelope.pdf",width = 4, height = 4,family = "Times")
    par(mar=c(mar_b, mar_e, mar_c, mar_d))
    par(mgp=c(dist_text, dist_tick, 0))
    med <- apply(e,1,median)
    qq <- qnorm((n+1:n+.5)/(2*n+1.125))
    plot(qq, sort(abs(res)), ylim = range(abs(res), e1, e2), 
         pch=pch, xlab=xlab, ylab=ylab)
    
    lines(qq,e1,lty=1)
    lines(qq,e2,lty=1)
    lines(qq,med,lty=2) 
    dev.off()  
  }
}