############################################################################################################
#
# Example to fit the model proposed by:            
# Canterle, D.R. and Bayer, F.M. (2015) Variable dispersion beta regressions with parametric link functions
#
############################################################################################################

source("br.fit.pl.R") # read the main function

data<-read.table("data.txt",h=T) # read the data set
head(data)
attach(data)

X<-cbind(x1,x2) # mean covariates 
Z<-cbind(x3,x4) # dispersion covariates 

fit <- br.fit(X,Z,y) # fit the model

reset(fit) # RESET test
diag.br.fit(fit) # diagnostic graphs
diag.br.fit(fit,sim=50,conf=.95, pch=3, pdf=1) # with some options
