%%%% Classe LaTex - WorkMicro - ver. 1.0 (05/07/2017)  fpuhales@gmail.com
\NeedsTeXFormat{LaTeX2e}
\RequirePackage{graphicx}
\RequirePackage[utf8]{inputenc}
\RequirePackage{setspace}
\RequirePackage{ifthen}
\newif\if@submissao
\@submissaofalse
\DeclareOption{submissao}{\global\@submissaotrue}

\ProcessOptions
\LoadClass[11pt,a4paper]{article}


\usepackage{indentfirst}
\usepackage{setspace}
\usepackage{authblk}
\renewcommand\Authsep{, }
\renewcommand\Authand{ e }
\renewcommand\Authands{ e }

\usepackage{fancyhdr}
\usepackage{geometry}
\usepackage{lastpage}
\usepackage{lineno}
\usepackage[]{hyperref}
\hypersetup{}
\usepackage[brazil]{babel}
\usepackage[alf,recuo=0.7cm,abnt-etal-cite=3,abnt-etal-list=0,abnt-emphasize=bf,abnt-repeated-author-omit=no,abnt-thesis-year=both,abnt-etal-text=default,abnt-and-type=e,abnt-full-initials=no]{abntex2cite}
\usepackage{epstopdf}
\usepackage{graphicx}
\usepackage{lipsum}
\usepackage{enumerate}
\usepackage{wrapfig,framed}
\usepackage[]{caption}
\captionsetup[table]{font=normalsize,justification=justified,singlelinecheck=off,labelsep=endash}
\captionsetup[figure]{font=normalsize,justification=justified,singlelinecheck=off,labelsep=endash}
\usepackage[]{subcaption}

\usepackage{amsfonts}
\usepackage{amssymb}
\usepackage{amsmath}

% \usepackage{helvet}
% \DeclareCaptionFont{\sffamily}

%%%  fonte
\usepackage{helvet}
\usepackage{mathptmx}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
%\definecolor{azulcen}{rgb}{0.4941176,0.6827451,0.86666666666666}
\definecolor{azulcen}{rgb}{0.1211,0.2813,0.4609}
% % 31,72,118  RGB
% % % #1F4876  html
\newcommand{\fonteppp}{\scriptsize}
\newcommand{\fontepp}{\footnotesize}
\newcommand{\fontep}{\small}
\newcommand{\fonten}{\normalsize}
\newcommand{\fonteg}{\large}
\newcommand{\fontegg}{\Large}
\newcommand{\fonteggg}{\LARGE}

% margens

%   Defining the page size
%   Defining the page size
\setlength{\paperheight}{297mm}
\setlength{\paperwidth}{210mm}
\setlength{\voffset}{-2cm}
\setlength{\topmargin}{0cm}
\setlength{\headheight}{1cm}
\setlength{\headsep}{0.5cm}
\setlength{\footskip}{0cm}
\setlength{\textheight}{25.7cm}
\setlength{\oddsidemargin}{-0.5cm}
\setlength{\hoffset}{0cm}
\setlength{\marginparsep}{0mm}
\setlength{\marginparwidth}{0mm}    
\setlength{\marginparpush}{0mm}
\setlength{\marginparwidth}{0mm}    
\setlength{\textwidth}{17cm}
\setlength{\parindent}{1.25cm}

    \def\ps@WORKMICROhead{%
        
      \def\@oddfoot{%
      \parbox{\textwidth}{\begin{center}\sffamily\fontep \thepage\end{center}}}%
      \let\@evenfoot\@empty

      \def\@oddhead{%
      \parbox{\textwidth}{\begin{flushright}\sffamily\bfseries\fontepp{X Workshop Brasileiro de Micrometeorologia, Santa Maria-RS, 8-10 de novembro de 2017.}\end{flushright}}}%
      \let\@evenhead\@empty
}


    \def\ps@WORKMICROheadum{%
        \let\@oddhead\@empty
        \let\@oddfoot\@empty
        \let\@evenhead\@empty
        \let\@evenfoot\@empty
}


% titulos de secao

\renewcommand{\section}{
   \@startsection{section}{1}{\z@}%
   {-11pt \@plus -1ex \@minus -.2ex}% espacamento antes
   {.3ex \@plus .2ex}% espacamento depois
   {\reset@font\fonteg\sffamily\bfseries\color{azulcen}}}
\renewcommand{\thesection}{\arabic{section}.\hspace{-1ex}}


\renewcommand{\subsection}{
   \@startsection{subsection}{1}{\z@}%
   {-11pt \@plus -1ex \@minus -.2ex}% espacamento antes
   {.3ex \@plus .2ex}% espacamento depois
   {\reset@font\fonteg\sffamily\color{azulcen}}}
\renewcommand{\thesubsection}{\hspace{\parindent}\arabic{section}.\arabic{subsection}\hspace{-1ex}}


% cabecalho do resumo
\newcommand{\titulo}{\title}
\newcommand{\autor}{\author}
\newcommand{\resumo}{\newcommand{\res}}
\newcommand{\palavrachave}{\newcommand{\chave}}
\newcommand{\resumoingles}{\newcommand{\abst}}
\newcommand{\keywords}{\newcommand{\key}}

\newcommand{\WORKMICRO@pagum}{%

    \begin{flushleft}
  \includegraphics[width=0.35\textwidth]{logo.png}
    \end{flushleft}



    \begin{center}
    {\noindent{\sffamily\bfseries \color{azulcen}\centering\fontegg\MakeUppercase\@title} \par}%

    \renewcommand\Authfont{}
    \renewcommand\Affilfont{\fontepp}
    
    \if@submissao

    \else

    \noindent\sffamily\fonten\@author
    \fi
    
%     \renewcommand\Authfont{}
%     \renewcommand\Affilfont{\sffamily\fontep}
%     \sffamily\fonten\@author

    \end{center}
    \vspace{\parskip}
    \begin{center}{\noindent\sffamily\bfseries\color{azulcen}\fonten Resumo}\end{center}
    \par {\sffamily\fontep\res}
    \par {\sffamily\fontep\textbf{Palavras-chave:~} \chave\\}
    
    \begin{center}{\noindent\sffamily\bfseries\color{azulcen}\fonten Abstract}\end{center}
    \par {\sffamily\fontep\abst}
    \par {\sffamily\fontep\textbf{Keywords:~} \key\\}
    
    }


\newenvironment{capa}{}{\inicio}

\newcommand\inicio{
    \thispagestyle{WORKMICROheadum}
    \if@twocolumn
	  \ifnum \col@number=\@ne
	    \WORKMICRO@pagum
	  \else
	    \twocolumn[\WORKMICRO@pagum]%
	  \fi
    \else
	  \global\@topnum\z@   % Prevents figures from going at top of page.
	  \WORKMICRO@pagum
    \fi
    
}



% % % % INICIA ambiente bibliografia
\newcommand\bibliografia[1]{
   \bibliography{#1}
}

    \renewenvironment{thebibliography}[1]
    {\section*{\bibname}%
    \list{\@biblabel{\@arabic\c@enumiv}}%
    {\settowidth\labelwidth{\@biblabel{#1}}%
    \leftmargin\labelwidth
    \advance\leftmargin\labelsep
    \@openbib@code
    \usecounter{enumiv}%
    \let\p@enumiv\@empty
    \renewcommand\theenumiv{\@arabic\c@enumiv}}%
    \singlespacing
    \sloppy
    \clubpenalty4000
    \@clubpenalty \clubpenalty
    \widowpenalty4000%
    \sfcode`\.\@m}
    {\def\@noitemerr
    {\@latex@warning{Empty `thebibliography' environment}}%
    \endlist}

\newcommand\corpo{
    \pagestyle{WORKMICROhead}
    \inicio
    \sffamily\fonten
    \renewcommand{\rmdefault}{phv} % Arial
    \renewcommand{\sfdefault}{phv} %Arial
 } 


\endinput

